#!/bin/sh
if [ $# -ne 1 ]
then
    echo "Usage: $0 <path-to-install-to>"
    exit 1
fi

dir="$1"

bin=`uname`
case $bin in
    Linux|SunOS)
        ;;
    *)
        echo "Your operating system ($bin) is not yet supported"
        exit 1
        ;;
esac

if [ ! -d "$dir" ]; then
    if mkdir "$dir"
    then
        echo "Created $dir"
    else
        echo "Unable to create $dir; stopping"
        exit 1
    fi
fi

cp2 (){
    if cp -pf "$1" "$2"
    then
        echo "'$1' -> '$2'"
    else
        echo "ERROR: unable to copy $1 to $2; stopping"
        exit 1
    fi
}

cp2 "../../gcc33_32bit/mdAddr.h" "$dir"
cp2 "../../gcc33_32bit/mdEnums.h" "$dir"

for f in Makefile mdAddrPHP.c mdAddrPHP.h *.php
do
    cp2 "$f" "$dir"
done

if ! chmod 666 $dir/mdAddrPHP.* $dir/Makefile $dir/*.php
then
    echo "WARNING: unable to set permissions on sample files"
fi

exit 0

